/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability.data;

import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.CapabilityKey;
import fuzs.puzzleslib.capability.data.SyncStrategy;
import fuzs.puzzleslib.capability.data.SyncedCapabilityComponent;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.network.S2CSyncCapabilityMessage;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public interface PlayerCapabilityKey<C extends CapabilityComponent>
extends CapabilityKey<C> {
    public void syncToRemote(class_3222 var1);

    public static <C extends CapabilityComponent> void syncCapabilityToRemote(class_1297 holder, class_3222 receiver, SyncStrategy syncStrategy, C capability, class_2960 id, boolean force) {
        if (syncStrategy != SyncStrategy.MANUAL) {
            if (!(capability instanceof SyncedCapabilityComponent)) {
                if (!force) {
                    throw new IllegalStateException("Unable to sync capability component that is not of type %s".formatted(SyncedCapabilityComponent.class));
                }
                return;
            }
            SyncedCapabilityComponent syncedCapability = (SyncedCapabilityComponent)capability;
            if (force || syncedCapability.isDirty()) {
                syncStrategy.sender.accept(new S2CSyncCapabilityMessage(id, holder, capability.toCompoundTag()), receiver);
                syncedCapability.markClean();
            }
        } else if (!force) {
            PuzzlesLib.LOGGER.warn("Attempting to sync capability {} that is set to manual syncing", (Object)id);
        }
    }
}

